/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.sort.DocumentOrderIterator;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class KeyFn
extends SystemFunction
implements XSLTFunction {
    private NamespaceResolver nsContext = null;
    private KeyDefinitionSet staticKeySet = null;
    private transient boolean checked = false;
    private transient boolean internal = false;
    private static final StructuredQName FN_KEY = new StructuredQName("fn", "http://www.w3.org/2005/xpath-functions", "key");

    public StructuredQName getStaticKeyName() {
        return this.staticKeySet == null ? null : this.staticKeySet.getKeyName();
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        try {
            return super.typeCheck(visitor, contextItemType);
        }
        catch (XPathException err) {
            if ("XPDY0002".equals(err.getErrorCodeLocalPart())) {
                XPathException e2 = new XPathException("Cannot call the key() function when there is no context node");
                e2.setErrorCode("XTDE1270");
                e2.maybeSetLocation(this);
                throw e2;
            }
            throw err;
        }
    }

    public static KeyFn internalKeyCall(KeyDefinitionSet keySet, String name, Expression value, Expression doc) {
        KeyFn k = new KeyFn();
        k.argument = new Expression[]{new StringLiteral(name), value, doc};
        k.staticKeySet = keySet;
        k.checked = true;
        k.internal = true;
        k.setDetails(StandardFunction.getFunction("key", 3));
        k.setFunctionName(FN_KEY);
        k.adoptChildExpression(value);
        k.adoptChildExpression(doc);
        return k;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        if (!this.internal && !(visitor.getStaticContext() instanceof ExpressionContext)) {
            throw new XPathException("The key() function is available only in XPath expressions within an XSLT stylesheet");
        }
        KeyFn f = (KeyFn)super.simplify(visitor);
        if (this.argument.length == 2) {
            f.addContextDocumentArgument(2, "key");
        }
        return f;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(visitor);
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.argument[1] = ExpressionTool.unsorted(opt, this.argument[1], false);
        if (this.argument[0] instanceof StringLiteral) {
            StructuredQName keyName;
            try {
                keyName = ((ExpressionContext)visitor.getStaticContext()).getStructuredQName(((StringLiteral)this.argument[0]).getStringValue(), false);
            }
            catch (XPathException e2) {
                XPathException err = new XPathException("Error in key name " + ((StringLiteral)this.argument[0]).getStringValue() + ": " + e2.getMessage());
                err.setLocator(this);
                err.setErrorCode("XTDE1260");
                throw err;
            }
            this.staticKeySet = visitor.getExecutable().getKeyManager().getKeyDefinitionSet(keyName);
            if (this.staticKeySet == null) {
                XPathException err = new XPathException("Key " + ((StringLiteral)this.argument[0]).getStringValue() + " has not been defined");
                err.setLocator(this);
                err.setErrorCode("XTDE1260");
                throw err;
            }
        } else {
            this.nsContext = visitor.getStaticContext().getNamespaceResolver();
        }
    }

    public int computeSpecialProperties() {
        int prop = 0xC20000;
        if (this.getNumberOfArguments() == 2 || (this.argument[2].getSpecialProperties() & 0x10000) != 0) {
            prop |= 0x10000;
        }
        return prop;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        this.argument[0].addToPathMap(pathMap, pathMapNodeSet);
        this.argument[1].addToPathMap(pathMap, pathMapNodeSet);
        PathMap.PathMapNodeSet target = this.argument[2].addToPathMap(pathMap, pathMapNodeSet);
        AxisExpression root = new AxisExpression(1, NodeKindTest.DOCUMENT);
        root.setContainer(this.getContainer());
        target = target.createArc(root);
        AxisExpression allElements = new AxisExpression(4, AnyNodeTest.getInstance());
        allElements.setContainer(this.getContainer());
        return target.createArc(allElements);
    }

    public Expression copy() {
        KeyFn k = (KeyFn)super.copy();
        k.nsContext = this.nsContext;
        k.staticKeySet = this.staticKeySet;
        k.internal = this.internal;
        k.checked = this.checked;
        return k;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator allResults;
        Expression expression;
        Item arg2;
        Controller controller = context.getController();
        try {
            arg2 = this.argument[2].evaluateItem(context);
        }
        catch (XPathException e2) {
            if ("XPDY0002".equals(e2.getErrorCodeLocalPart())) {
                this.dynamicError("Cannot call the key() function when there is no context item", "XTDE1270", context);
                return null;
            }
            if ("XPDY0050".equals(e2.getErrorCodeLocalPart())) {
                this.dynamicError("In the key() function, the node supplied in the third argument (or the context node if absent) must be in a tree whose root is a document node", "XTDE1270", context);
                return null;
            }
            if ("XPTY0020".equals(e2.getErrorCodeLocalPart())) {
                this.dynamicError("Cannot call the key() function when the context item is an atomic value", "XTDE1270", context);
                return null;
            }
            throw e2;
        }
        NodeInfo origin = (NodeInfo)arg2;
        NodeInfo root = origin.getRoot();
        if (root.getNodeKind() != 9) {
            this.dynamicError("In the key() function, the node supplied in the third argument (or the context node if absent) must be in a tree whose root is a document node", "XTDE1270", context);
            return null;
        }
        DocumentInfo doc = (DocumentInfo)root;
        KeyDefinitionSet selectedKeySet = this.staticKeySet;
        if (selectedKeySet == null) {
            String givenkeyname = this.argument[0].evaluateItem(context).getStringValue();
            StructuredQName qName = null;
            try {
                qName = StructuredQName.fromLexicalQName(givenkeyname, false, controller.getConfiguration().getNameChecker(), this.nsContext);
            }
            catch (XPathException err) {
                this.dynamicError("Invalid key name: " + err.getMessage(), "XTDE1260", context);
            }
            selectedKeySet = controller.getKeyManager().getKeyDefinitionSet(qName);
            if (selectedKeySet == null) {
                this.dynamicError("Key '" + givenkeyname + "' has not been defined", "XTDE1260", context);
                return null;
            }
        }
        if (Cardinality.allowsMany((expression = this.argument[1]).getCardinality())) {
            final XPathContext keyContext = context;
            final DocumentInfo document = doc;
            final KeyManager keyManager = controller.getKeyManager();
            final KeyDefinitionSet keySet = selectedKeySet;
            MappingFunction map = new MappingFunction(){

                public SequenceIterator map(Item item) throws XPathException {
                    return keyManager.selectByKey(keySet, document, (AtomicValue)item, keyContext);
                }
            };
            SequenceIterator keys = this.argument[1].iterate(context);
            MappingIterator allValues = new MappingIterator(keys, map);
            allResults = new DocumentOrderIterator(allValues, LocalOrderComparer.getInstance());
        } else {
            try {
                AtomicValue keyValue = (AtomicValue)this.argument[1].evaluateItem(context);
                if (keyValue == null) {
                    return EmptyIterator.getInstance();
                }
                KeyManager keyManager = controller.getKeyManager();
                allResults = keyManager.selectByKey(selectedKeySet, doc, keyValue, context);
            }
            catch (XPathException e3) {
                e3.maybeSetLocation(this);
                throw e3;
            }
        }
        if (origin == doc) {
            return allResults;
        }
        SubtreeFilter filter = new SubtreeFilter();
        filter.origin = origin;
        return new ItemMappingIterator(allResults, filter);
    }

    private static class SubtreeFilter
    implements ItemMappingFunction {
        public NodeInfo origin;

        private SubtreeFilter() {
        }

        public Item map(Item item) throws XPathException {
            if (Navigator.isAncestorOrSelf(this.origin, (NodeInfo)item)) {
                return item;
            }
            return null;
        }
    }
}

