/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class CallTemplate
extends Instruction {
    private Template template = null;
    private WithParam[] actualParams = null;
    private WithParam[] tunnelParams = null;
    private boolean useTailRecursion = false;
    private Expression calledTemplateExpression;
    private NamespaceResolver nsContext;

    public CallTemplate(Template template, boolean useTailRecursion, Expression calledTemplateExpression, NamespaceResolver nsContext) {
        this.template = template;
        this.useTailRecursion = useTailRecursion;
        this.calledTemplateExpression = calledTemplateExpression;
        this.nsContext = nsContext;
        this.adoptChildExpression(calledTemplateExpression);
    }

    public void setActualParameters(WithParam[] actualParams, WithParam[] tunnelParams) {
        int i;
        this.actualParams = actualParams;
        this.tunnelParams = tunnelParams;
        for (i = 0; i < actualParams.length; ++i) {
            this.adoptChildExpression(actualParams[i]);
        }
        for (i = 0; i < tunnelParams.length; ++i) {
            this.adoptChildExpression(tunnelParams[i]);
        }
    }

    public int getInstructionNameCode() {
        return 133;
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails details = (InstructionDetails)super.getInstructionInfo();
        if (this.template != null) {
            details.setProperty("template", this.template);
        }
        return details;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        WithParam.simplify(this.actualParams, visitor);
        WithParam.simplify(this.tunnelParams, visitor);
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = visitor.simplify(this.calledTemplateExpression);
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        WithParam.typeCheck(this.actualParams, visitor, contextItemType);
        WithParam.typeCheck(this.tunnelParams, visitor, contextItemType);
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = visitor.typeCheck(this.calledTemplateExpression, contextItemType);
            this.adoptChildExpression(this.calledTemplateExpression);
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        WithParam.optimize(visitor, this.actualParams, contextItemType);
        WithParam.optimize(visitor, this.tunnelParams, contextItemType);
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = visitor.optimize(this.calledTemplateExpression, contextItemType);
            this.adoptChildExpression(this.calledTemplateExpression);
        }
        return this;
    }

    public int computeCardinality() {
        if (this.template == null) {
            return 57344;
        }
        return this.template.getRequiredType().getCardinality();
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.template == null) {
            return AnyItemType.getInstance();
        }
        return this.template.getRequiredType().getPrimaryType();
    }

    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    public int getIntrinsicDependencies() {
        return 639;
    }

    public final boolean createsNewNodes() {
        return true;
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(10);
        if (this.calledTemplateExpression != null) {
            list.add(this.calledTemplateExpression);
        }
        WithParam.getXPathExpressions(this.actualParams, list);
        WithParam.getXPathExpressions(this.tunnelParams, list);
        return list.iterator();
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (WithParam.replaceXPathExpression(this.actualParams, original, replacement)) {
            found = true;
        }
        if (WithParam.replaceXPathExpression(this.tunnelParams, original, replacement)) {
            found = true;
        }
        if (this.calledTemplateExpression == original) {
            this.calledTemplateExpression = replacement;
        }
        return found;
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = this.doPromotion(this.calledTemplateExpression, offer);
        }
        WithParam.promoteParams(this.actualParams, offer);
        WithParam.promoteParams(this.tunnelParams, offer);
    }

    public void process(XPathContext context) throws XPathException {
        Template t = this.getTargetTemplate(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.openStackFrame(t.getStackFrameMap());
        c2.setLocalParameters(CallTemplate.assembleParams(context, this.actualParams));
        c2.setTunnelParameters(CallTemplate.assembleTunnelParams(context, this.tunnelParams));
        try {
            for (TailCall tc = t.expand(c2); tc != null; tc = tc.processLeavingTail()) {
            }
        }
        catch (StackOverflowError e2) {
            XPathException err = new XPathException("Too many nested template or function calls. The stylesheet may be looping.");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        if (!this.useTailRecursion) {
            this.process(context);
            return null;
        }
        Template target = this.getTargetTemplate(context);
        ParameterSet params = CallTemplate.assembleParams(context, this.actualParams);
        ParameterSet tunnels = CallTemplate.assembleTunnelParams(context, this.tunnelParams);
        if (params == null) {
            params = ParameterSet.EMPTY_PARAMETER_SET;
        }
        Arrays.fill(context.getStackFrame().getStackFrameValues(), null);
        return new CallTemplatePackage(target, params, tunnels, context);
    }

    public Template getTargetTemplate(XPathContext context) throws XPathException {
        if (this.calledTemplateExpression != null) {
            String localName;
            String prefix;
            Controller controller = context.getController();
            CharSequence qname = this.calledTemplateExpression.evaluateAsString(context);
            try {
                String[] parts = controller.getConfiguration().getNameChecker().getQNameParts(qname);
                prefix = parts[0];
                localName = parts[1];
            }
            catch (QNameException err) {
                this.dynamicError("Invalid template name. " + err.getMessage(), "XTSE0650", context);
                return null;
            }
            String uri = this.nsContext.getURIForPrefix(prefix, false);
            if (uri == null) {
                this.dynamicError("Namespace prefix " + prefix + " has not been declared", "XTSE0650", context);
            }
            StructuredQName qName = new StructuredQName("", uri, localName);
            Template target = controller.getExecutable().getNamedTemplate(qName);
            if (target == null) {
                this.dynamicError("Template " + qname + " has not been defined", "XTSE0650", context);
            }
            return target;
        }
        return this.template;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("callTemplate");
        if (this.template != null) {
            out.emitAttribute("name", this.template.getTemplateName() == null ? "null" : this.template.getTemplateName().getDisplayName());
        } else {
            out.startSubsidiaryElement("name");
            this.calledTemplateExpression.explain(out);
            out.endSubsidiaryElement();
        }
        if (this.actualParams != null && this.actualParams.length > 0) {
            out.startSubsidiaryElement("withParams");
            WithParam.displayExpressions(this.actualParams, out);
            out.endSubsidiaryElement();
        }
        if (this.tunnelParams != null && this.tunnelParams.length > 0) {
            out.startSubsidiaryElement("tunnelParams");
            WithParam.displayExpressions(this.tunnelParams, out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    private class CallTemplatePackage
    implements TailCall {
        private Template target;
        private ParameterSet params;
        private ParameterSet tunnelParams;
        private XPathContext evaluationContext;

        public CallTemplatePackage(Template template, ParameterSet params, ParameterSet tunnelParams, XPathContext evaluationContext) {
            this.target = template;
            this.params = params;
            this.tunnelParams = tunnelParams;
            this.evaluationContext = evaluationContext;
        }

        public TailCall processLeavingTail() throws XPathException {
            XPathContextMajor c2 = this.evaluationContext.newContext();
            c2.setOrigin(CallTemplate.this);
            c2.setLocalParameters(this.params);
            c2.setTunnelParameters(this.tunnelParams);
            c2.openStackFrame(this.target.getStackFrameMap());
            return this.target.expand(c2);
        }
    }
}

