/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.ApplyImports;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;

public class NextMatch
extends ApplyImports {
    public NextMatch(boolean backwardsCompatible) {
        super(backwardsCompatible);
    }

    public int getInstructionNameCode() {
        return 159;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        ParameterSet params = NextMatch.assembleParams(context, this.actualParams);
        ParameterSet tunnels = NextMatch.assembleTunnelParams(context, this.tunnelParams);
        Rule currentRule = context.getCurrentTemplateRule();
        if (currentRule == null) {
            XPathException e2 = new XPathException("There is no current template rule");
            e2.setXPathContext(context);
            e2.setErrorCode("XTDE0560");
            throw e2;
        }
        Mode mode = context.getCurrentMode();
        if (mode == null) {
            mode = controller.getRuleManager().getDefaultMode();
        }
        if (context.getCurrentIterator() == null) {
            XPathException e3 = new XPathException("There is no context item");
            e3.setXPathContext(context);
            e3.setErrorCode("XTDE0565");
            throw e3;
        }
        Item currentItem = context.getCurrentIterator().current();
        if (!(currentItem instanceof NodeInfo)) {
            XPathException e4 = new XPathException("Cannot call xsl:next-match when context item is not a node");
            e4.setXPathContext(context);
            e4.setErrorCode("XTDE0565");
            throw e4;
        }
        NodeInfo node = (NodeInfo)currentItem;
        Rule rule = controller.getRuleManager().getNextMatchHandler(node, mode, currentRule, context);
        if (rule == null) {
            ApplyTemplates.defaultAction(node, params, tunnels, context, false, this.getLocationId());
        } else {
            Template nh = (Template)rule.getAction();
            XPathContextMajor c2 = context.newContext();
            c2.setOrigin(this);
            c2.openStackFrame(nh.getStackFrameMap());
            c2.setLocalParameters(params);
            c2.setTunnelParameters(tunnels);
            nh.apply(c2, rule);
        }
        return null;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("nextMatch");
        if (this.actualParams != null && this.actualParams.length > 0) {
            out.startSubsidiaryElement("withParams");
            WithParam.displayExpressions(this.actualParams, out);
            out.endSubsidiaryElement();
        }
        if (this.tunnelParams != null && this.tunnelParams.length > 0) {
            out.startSubsidiaryElement("tunnelParams");
            WithParam.displayExpressions(this.tunnelParams, out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }
}

