/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.Controller;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Choose;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.ParentNodeConstructor;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sort.SortExpression;
import net.sf.saxon.sort.TupleSorter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public final class UserFunction
extends Procedure
implements InstructionInfoProvider {
    private StructuredQName functionName;
    private boolean memoFunction = false;
    private boolean tailCalls = false;
    private boolean tailRecursive = false;
    private UserFunctionParameter[] parameterDefinitions;
    private SequenceType resultType;
    private int evaluationMode = -1;
    private transient InstructionDetails details = null;

    public UserFunction() {
    }

    public UserFunction(Expression body) {
        this.setBody(body);
    }

    public void setFunctionName(StructuredQName name) {
        this.functionName = name;
    }

    public StructuredQName getFunctionName() {
        return this.functionName;
    }

    public void computeEvaluationMode() {
        this.evaluationMode = this.tailRecursive || this.memoFunction ? ExpressionTool.eagerEvaluationMode(this.getBody()) : ExpressionTool.lazyEvaluationMode(this.getBody());
    }

    public void setParameterDefinitions(UserFunctionParameter[] params) {
        this.parameterDefinitions = params;
    }

    public UserFunctionParameter[] getParameterDefinitions() {
        return this.parameterDefinitions;
    }

    public void setResultType(SequenceType resultType) {
        this.resultType = resultType;
    }

    public void setTailRecursive(boolean tailCalls, boolean recursiveTailCalls) {
        this.tailCalls = tailCalls;
        this.tailRecursive = recursiveTailCalls;
    }

    public boolean containsTailCalls() {
        return this.tailCalls;
    }

    public boolean isTailRecursive() {
        return this.tailRecursive;
    }

    public SequenceType getResultType(TypeHierarchy th) {
        if (this.resultType == SequenceType.ANY_SEQUENCE && !UserFunction.containsUserFunctionCalls(this.getBody())) {
            this.resultType = SequenceType.makeSequenceType(this.getBody().getItemType(th), this.getBody().getCardinality());
        }
        return this.resultType;
    }

    private static boolean containsUserFunctionCalls(Expression exp) {
        if (exp instanceof UserFunctionCall) {
            return true;
        }
        Iterator i = exp.iterateSubExpressions();
        while (i.hasNext()) {
            Expression e2 = (Expression)i.next();
            if (!UserFunction.containsUserFunctionCalls(e2)) continue;
            return true;
        }
        return false;
    }

    public SequenceType getArgumentType(int n) {
        return this.parameterDefinitions[n].getRequiredType();
    }

    public int getEvaluationMode() {
        if (this.evaluationMode == -1) {
            this.computeEvaluationMode();
        }
        return this.evaluationMode;
    }

    public int getNumberOfArguments() {
        return this.parameterDefinitions.length;
    }

    public void setMemoFunction(boolean isMemo) {
        this.memoFunction = isMemo;
    }

    public boolean isMemoFunction() {
        return this.memoFunction;
    }

    public void gatherDirectContributingCallees(Set result) {
        Expression body = this.getBody();
        this.gatherDirectContributingCallees(body, result);
    }

    private void gatherDirectContributingCallees(Expression exp, Set result) {
        Iterator kids = exp.iterateSubExpressions();
        while (kids.hasNext()) {
            Expression kid = (Expression)kids.next();
            if (kid instanceof UserFunctionCall) {
                result.add(((UserFunctionCall)kid).getFunction());
                continue;
            }
            if (kid instanceof Assignation) {
                this.gatherDirectContributingCallees(((Assignation)kid).getAction(), result);
                continue;
            }
            if (kid instanceof Choose) {
                Expression[] actions = ((Choose)kid).getActions();
                for (int c = 0; c < actions.length; ++c) {
                    this.gatherDirectContributingCallees(actions[c], result);
                }
                continue;
            }
            if (kid instanceof ParentNodeConstructor) {
                this.gatherDirectContributingCallees(((ParentNodeConstructor)kid).getContentExpression(), result);
                continue;
            }
            if (kid instanceof FilterExpression) {
                this.gatherDirectContributingCallees(((FilterExpression)kid).getBaseExpression(), result);
                continue;
            }
            if (kid instanceof SortExpression) {
                this.gatherDirectContributingCallees(((SortExpression)kid).getBaseExpression(), result);
                continue;
            }
            if (kid instanceof TupleSorter) {
                this.gatherDirectContributingCallees(((TupleSorter)kid).getBaseExpression(), result);
                continue;
            }
            if (!(kid instanceof TailCallLoop)) continue;
            this.gatherDirectContributingCallees(((TailCallLoop)kid).getBaseExpression(), result);
        }
    }

    public ValueRepresentation call(ValueRepresentation[] actualArgs, XPathContextMajor context) throws XPathException {
        ValueRepresentation result;
        ValueRepresentation value;
        Controller controller = context.getController();
        if (this.memoFunction && (value = this.getCachedValue(controller, actualArgs)) != null) {
            return value;
        }
        if (this.evaluationMode == -1) {
            this.computeEvaluationMode();
        }
        context.setStackFrame(this.getStackFrameMap(), actualArgs);
        try {
            result = ExpressionTool.evaluate(this.getBody(), this.evaluationMode, context, 1);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
        if (this.memoFunction) {
            this.putCachedValue(controller, actualArgs, result);
        }
        return result;
    }

    public void process(ValueRepresentation[] actualArgs, XPathContextMajor context) throws XPathException {
        context.setStackFrame(this.getStackFrameMap(), actualArgs);
        this.getBody().process(context);
    }

    public EventIterator iterateEvents(ValueRepresentation[] actualArgs, XPathContextMajor context) throws XPathException {
        context.setStackFrame(this.getStackFrameMap(), actualArgs);
        return this.getBody().iterateEvents(context);
    }

    public ValueRepresentation call(ValueRepresentation[] actualArgs, Controller controller) throws XPathException {
        return this.call(actualArgs, controller.newXPathContext());
    }

    private ValueRepresentation getCachedValue(Controller controller, ValueRepresentation[] params) throws XPathException {
        HashMap map = (HashMap)controller.getUserData(this, "memo-function-cache");
        if (map == null) {
            return null;
        }
        String key = UserFunction.getCombinedKey(params);
        return (ValueRepresentation)map.get(key);
    }

    private void putCachedValue(Controller controller, ValueRepresentation[] params, ValueRepresentation value) throws XPathException {
        HashMap<String, ValueRepresentation> map = (HashMap<String, ValueRepresentation>)controller.getUserData(this, "memo-function-cache");
        if (map == null) {
            map = new HashMap<String, ValueRepresentation>(32);
            controller.setUserData(this, "memo-function-cache", map);
        }
        String key = UserFunction.getCombinedKey(params);
        map.put(key, value);
    }

    private static String getCombinedKey(ValueRepresentation[] params) throws XPathException {
        FastStringBuffer sb = new FastStringBuffer(120);
        for (int i = 0; i < params.length; ++i) {
            Item item;
            ValueRepresentation val = params[i];
            SequenceIterator iter = Value.getIterator(val);
            while ((item = iter.next()) != null) {
                if (item instanceof NodeInfo) {
                    NodeInfo node = (NodeInfo)item;
                    node.generateId(sb);
                } else {
                    sb.append("" + Type.displayTypeName(item));
                    sb.append('/');
                    sb.append(item.getStringValueCS());
                }
                sb.append('\u0001');
            }
            sb.append('\u0002');
        }
        return sb.toString();
    }

    public InstructionInfo getInstructionInfo() {
        if (this.details == null) {
            this.details = new InstructionDetails();
            this.details.setSystemId(this.getSystemId());
            this.details.setLineNumber(this.getLineNumber());
            this.details.setConstructType(149);
            this.details.setObjectName(this.functionName);
            this.details.setProperty("function", this);
        }
        return this.details;
    }
}

