/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import java.util.ArrayList;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeListIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.LineNumberMap;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.ParentNodeImpl;
import net.sf.saxon.tree.SystemIdMap;
import net.sf.saxon.value.Whitespace;

public final class DocumentImpl
extends ParentNodeImpl
implements DocumentInfo {
    private ElementImpl documentElement;
    private HashMap idTable = null;
    private int documentNumber;
    private String baseURI;
    private HashMap entityTable = null;
    private HashMap elementList = null;
    private Configuration config;
    private LineNumberMap lineNumberMap;
    private SystemIdMap systemIdMap = new SystemIdMap();

    public DocumentImpl() {
        this.parent = null;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.documentNumber = config.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    void setDocumentElement(ElementImpl e2) {
        this.documentElement = e2;
    }

    public void setSystemId(String uri) {
        if (uri == null) {
            uri = "";
        }
        this.systemIdMap.setSystemId(this.sequence, uri);
    }

    public String getSystemId() {
        return this.systemIdMap.getSystemId(this.sequence);
    }

    public void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    public String getBaseURI() {
        if (this.baseURI != null) {
            return this.baseURI;
        }
        return this.getSystemId();
    }

    void setSystemId(int seq2, String uri) {
        if (uri == null) {
            uri = "";
        }
        this.systemIdMap.setSystemId(seq2, uri);
    }

    String getSystemId(int seq2) {
        return this.systemIdMap.getSystemId(seq2);
    }

    public void setLineNumbering() {
        this.lineNumberMap = new LineNumberMap();
        this.lineNumberMap.setLineNumber(this.sequence, 0);
    }

    void setLineNumber(int sequence, int line) {
        if (this.lineNumberMap != null) {
            this.lineNumberMap.setLineNumber(sequence, line);
        }
    }

    int getLineNumber(int sequence) {
        if (this.lineNumberMap != null) {
            return this.lineNumberMap.getLineNumber(sequence);
        }
        return -1;
    }

    public int getLineNumber() {
        return 0;
    }

    public final int getNodeKind() {
        return 9;
    }

    public final NodeInfo getNextSibling() {
        return null;
    }

    public final NodeInfo getPreviousSibling() {
        return null;
    }

    public ElementImpl getDocumentElement() {
        return this.documentElement;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return this;
    }

    public void generateId(FastStringBuffer buffer) {
        buffer.append('d');
        buffer.append(Integer.toString(this.documentNumber));
    }

    AxisIterator getAllElements(int fingerprint) {
        ArrayList<NodeImpl> list;
        Integer elkey = new Integer(fingerprint);
        if (this.elementList == null) {
            this.elementList = new HashMap(500);
        }
        if ((list = (ArrayList<NodeImpl>)this.elementList.get(elkey)) == null) {
            list = new ArrayList<NodeImpl>(500);
            for (NodeImpl next = this.getNextInDocument(this); next != null; next = next.getNextInDocument(this)) {
                if (next.getNodeKind() != 1 || next.getFingerprint() != fingerprint) continue;
                list.add(next);
            }
            this.elementList.put(elkey, list);
        }
        return new NodeListIterator(list);
    }

    private void indexIDs() {
        NodeImpl curr;
        if (this.idTable != null) {
            return;
        }
        this.idTable = new HashMap(256);
        NameChecker checker = this.getConfiguration().getNameChecker();
        DocumentImpl root = curr = this;
        while (curr != null) {
            if (curr.getNodeKind() == 1) {
                ElementImpl e2 = (ElementImpl)curr;
                AttributeCollection atts = e2.getAttributeList();
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (!atts.isId(i) || !checker.isValidNCName(Whitespace.trim(atts.getValue(i)))) continue;
                    this.registerID(e2, Whitespace.trim(atts.getValue(i)));
                }
            }
            curr = curr.getNextInDocument(root);
        }
    }

    private void registerID(NodeInfo e2, String id) {
        Object old = this.idTable.get(id);
        if (old == null) {
            this.idTable.put(id, e2);
        }
    }

    public NodeInfo selectID(String id) {
        if (this.idTable == null) {
            this.indexIDs();
        }
        return (NodeInfo)this.idTable.get(id);
    }

    void setUnparsedEntity(String name, String uri, String publicId) {
        if (this.entityTable == null) {
            this.entityTable = new HashMap(10);
        }
        String[] ids = new String[]{uri, publicId};
        this.entityTable.put(name, ids);
    }

    public String[] getUnparsedEntity(String name) {
        if (this.entityTable == null) {
            return null;
        }
        return (String[])this.entityTable.get(name);
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        out.startDocument(0);
        for (NodeImpl next = (NodeImpl)this.getFirstChild(); next != null; next = (NodeImpl)next.getNextSibling()) {
            next.copy(out, whichNamespaces, copyAnnotations, locationId);
        }
        out.endDocument();
    }
}

