/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public final class Int64Value
extends IntegerValue {
    private long value;

    public Int64Value(long value) {
        this.value = value;
        this.typeLabel = BuiltInAtomicType.INTEGER;
    }

    public Int64Value(long val, BuiltInAtomicType type, boolean check) throws XPathException {
        this.value = val;
        this.typeLabel = type;
        if (check && !Int64Value.checkRange(this.value, type)) {
            XPathException err = new XPathException("Integer value " + val + " is out of range for the requested type " + type.getDescription());
            err.setErrorCode("XPTY0004");
            err.setIsTypeError(true);
            throw err;
        }
    }

    public static Int64Value makeIntegerValue(long value) {
        if (value <= 20L && value >= 0L) {
            return SMALL_INTEGERS[(int)value];
        }
        return new Int64Value(value);
    }

    public static Int64Value makeDerived(long val, AtomicType type) {
        Int64Value v = new Int64Value(val);
        v.typeLabel = type;
        return v;
    }

    public static Int64Value signum(long val) {
        if (val == 0L) {
            return IntegerValue.ZERO;
        }
        return val < 0L ? IntegerValue.MINUS_ONE : IntegerValue.PLUS_ONE;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        Int64Value v = new Int64Value(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public ValidationFailure convertToSubType(BuiltInAtomicType subtype, boolean validate) {
        if (!validate) {
            this.setSubType(subtype);
            return null;
        }
        if (this.checkRange(subtype)) {
            return null;
        }
        ValidationFailure err = new ValidationFailure("String " + this.value + " cannot be converted to integer subtype " + subtype.getDescription());
        err.setErrorCode("FORG0001");
        return err;
    }

    public ValidationFailure validateAgainstSubType(BuiltInAtomicType type) {
        if (Int64Value.checkRange(this.value, type)) {
            return null;
        }
        ValidationFailure err = new ValidationFailure("Value " + this.value + " cannot be converted to integer subtype " + type.getDescription());
        err.setErrorCode("FORG0001");
        return err;
    }

    public void setSubType(AtomicType type) {
        this.typeLabel = type;
    }

    public boolean checkRange(BuiltInAtomicType type) {
        this.typeLabel = type;
        return Int64Value.checkRange(this.value, type);
    }

    public Comparable getSchemaComparable() {
        return new Int64Comparable(this);
    }

    public int hashCode() {
        if (this.value > Integer.MIN_VALUE && this.value < Integer.MAX_VALUE) {
            return (int)this.value;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public long longValue() {
        return this.value;
    }

    public boolean effectiveBooleanValue() {
        return this.value != 0L;
    }

    public int compareTo(Object other) {
        if (other instanceof Int64Value) {
            long val2 = ((Int64Value)other).value;
            if (this.value == val2) {
                return 0;
            }
            if (this.value < val2) {
                return -1;
            }
            return 1;
        }
        if (other instanceof BigIntegerValue) {
            return new BigIntegerValue(this.value).compareTo(other);
        }
        return super.compareTo(other);
    }

    public int compareTo(long other) {
        if (this.value == other) {
            return 0;
        }
        if (this.value < other) {
            return -1;
        }
        return 1;
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getFingerprint()) {
            case 514: {
                return BooleanValue.get(this.value != 0L);
            }
            case 532: 
            case 632: 
            case 635: {
                if (this.typeLabel == BuiltInAtomicType.INTEGER) {
                    return this;
                }
                return this.copyAsSubType(BuiltInAtomicType.INTEGER);
            }
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: {
                Int64Value val = new Int64Value(this.value);
                ValidationFailure err = val.convertToSubType(requiredType, validate);
                if (err != null) {
                    return err;
                }
                return val;
            }
            case 517: {
                return new DoubleValue(this.value);
            }
            case 516: {
                return new FloatValue(this.value);
            }
            case 515: {
                return new DecimalValue(this.value);
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        ValidationFailure err2 = new ValidationFailure("Cannot convert integer to " + requiredType.getDisplayName());
        err2.setErrorCode("XPTY0004");
        return err2;
    }

    public String getStringValue() {
        return Long.toString(this.value);
    }

    public double getDoubleValue() {
        return this.value;
    }

    public float getFloatValue() {
        return this.value;
    }

    public BigDecimal getDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }

    public NumericValue negate() {
        if (this.value == Long.MIN_VALUE) {
            return BigIntegerValue.makeIntegerValue(BigInteger.valueOf(this.value)).negate();
        }
        return new Int64Value(-this.value);
    }

    public NumericValue floor() {
        return this;
    }

    public NumericValue ceiling() {
        return this;
    }

    public NumericValue round() {
        return this;
    }

    public NumericValue roundHalfToEven(int scale) {
        long absolute = Math.abs(this.value);
        if (scale >= 0) {
            return this;
        }
        if (scale < -15) {
            return new BigIntegerValue(this.value).roundHalfToEven(scale);
        }
        long factor = 1L;
        for (long i = 1L; i <= (long)(-scale); ++i) {
            factor *= 10L;
        }
        long modulus = absolute % factor;
        long rval = absolute - modulus;
        long d = modulus * 2L;
        if (d > factor) {
            rval += factor;
        } else if (d >= factor && rval % (2L * factor) != 0L) {
            rval += factor;
        }
        if (this.value < 0L) {
            rval = -rval;
        }
        return new Int64Value(rval);
    }

    public double signum() {
        if (this.value > 0L) {
            return 1.0;
        }
        if (this.value == 0L) {
            return 0.0;
        }
        return -1.0;
    }

    public IntegerValue plus(IntegerValue other) {
        if (other instanceof Int64Value) {
            long topa = this.value >> 60 & 0xFL;
            if (topa != 0L && topa != 15L) {
                return new BigIntegerValue(this.value).plus(new BigIntegerValue(((Int64Value)other).value));
            }
            long topb = ((Int64Value)other).value >> 60 & 0xFL;
            if (topb != 0L && topb != 15L) {
                return new BigIntegerValue(this.value).plus(new BigIntegerValue(((Int64Value)other).value));
            }
            return Int64Value.makeIntegerValue(this.value + ((Int64Value)other).value);
        }
        return new BigIntegerValue(this.value).plus(other);
    }

    public IntegerValue minus(IntegerValue other) {
        if (other instanceof Int64Value) {
            long topa = this.value >> 60 & 0xFL;
            if (topa != 0L && topa != 15L) {
                return new BigIntegerValue(this.value).minus(new BigIntegerValue(((Int64Value)other).value));
            }
            long topb = ((Int64Value)other).value >> 60 & 0xFL;
            if (topb != 0L && topb != 15L) {
                return new BigIntegerValue(this.value).minus(new BigIntegerValue(((Int64Value)other).value));
            }
            return Int64Value.makeIntegerValue(this.value - ((Int64Value)other).value);
        }
        return new BigIntegerValue(this.value).minus(other);
    }

    public IntegerValue times(IntegerValue other) {
        if (other instanceof Int64Value) {
            long topa = this.value >> 32;
            if (topa != 0L && topa != -1L) {
                return new BigIntegerValue(this.value).times(new BigIntegerValue(((Int64Value)other).value));
            }
            long topb = ((Int64Value)other).value >> 32;
            if (topb != 0L && topb != -1L) {
                return new BigIntegerValue(this.value).times(new BigIntegerValue(((Int64Value)other).value));
            }
            return Int64Value.makeIntegerValue(this.value * ((Int64Value)other).value);
        }
        return new BigIntegerValue(this.value).times(other);
    }

    public NumericValue div(IntegerValue other) throws XPathException {
        if (other instanceof Int64Value) {
            long topa = this.value >> 32;
            if (topa != 0L && topa != -1L) {
                return new BigIntegerValue(this.value).div(new BigIntegerValue(((Int64Value)other).value));
            }
            long topb = ((Int64Value)other).value >> 32;
            if (topb != 0L && topb != -1L) {
                return new BigIntegerValue(this.value).div(new BigIntegerValue(((Int64Value)other).value));
            }
            long quotient = ((Int64Value)other).value;
            if (quotient == 0L) {
                throw new XPathException("Integer division by zero", "FOAR0001");
            }
            if (this.value % quotient == 0L) {
                return Int64Value.makeIntegerValue(this.value / quotient);
            }
            return (NumericValue)Calculator.DECIMAL_DECIMAL[3].compute(new DecimalValue(this.value), new DecimalValue(quotient), null);
        }
        return new BigIntegerValue(this.value).div(other);
    }

    public IntegerValue mod(IntegerValue other) throws XPathException {
        if (other instanceof Int64Value) {
            long topa = this.value >> 32;
            if (topa != 0L && topa != -1L) {
                return new BigIntegerValue(this.value).mod(new BigIntegerValue(((Int64Value)other).value));
            }
            long quotient = ((Int64Value)other).value;
            if (quotient == 0L) {
                throw new XPathException("Integer modulo zero", "FOAR0001");
            }
            long topb = quotient >> 32;
            if (topb != 0L && topb != -1L) {
                return new BigIntegerValue(this.value).mod(new BigIntegerValue(((Int64Value)other).value));
            }
            return Int64Value.makeIntegerValue(this.value % quotient);
        }
        return new BigIntegerValue(this.value).mod(other);
    }

    public IntegerValue idiv(IntegerValue other) throws XPathException {
        if (other instanceof Int64Value) {
            long topa = this.value >> 32;
            if (topa != 0L && topa != -1L) {
                return new BigIntegerValue(this.value).idiv(new BigIntegerValue(((Int64Value)other).value));
            }
            long topb = ((Int64Value)other).value >> 32;
            if (topb != 0L && topb != -1L) {
                return new BigIntegerValue(this.value).idiv(new BigIntegerValue(((Int64Value)other).value));
            }
            try {
                return Int64Value.makeIntegerValue(this.value / ((Int64Value)other).value);
            }
            catch (ArithmeticException err) {
                XPathException e2 = "/ by zero".equals(err.getMessage()) ? new XPathException("Integer division by zero", "FOAR0001") : new XPathException("Integer division failure", err);
                throw e2;
            }
        }
        return new BigIntegerValue(this.value).idiv(other);
    }

    public BigInteger asBigInteger() {
        return BigInteger.valueOf(this.value);
    }

    public Object convertToJava(Class target, XPathContext context) throws XPathException {
        if (target == Object.class) {
            return new Long(this.value);
        }
        if (target.isAssignableFrom(Int64Value.class)) {
            return this;
        }
        if (target == Boolean.TYPE) {
            BooleanValue bval = (BooleanValue)this.convertPrimitive(BuiltInAtomicType.BOOLEAN, true, context).asAtomic();
            return bval.getBooleanValue();
        }
        if (target == Boolean.class) {
            BooleanValue bval = (BooleanValue)this.convertPrimitive(BuiltInAtomicType.BOOLEAN, true, context).asAtomic();
            return bval.getBooleanValue();
        }
        if (target == String.class || target == CharSequence.class) {
            return this.getStringValue();
        }
        if (target == Double.TYPE || target == Double.class) {
            return new Double(this.value);
        }
        if (target == Float.TYPE || target == Float.class) {
            return new Float(this.value);
        }
        if (target == Long.TYPE || target == Long.class) {
            return new Long(this.value);
        }
        if (target == Integer.TYPE || target == Integer.class) {
            return new Integer((int)this.value);
        }
        if (target == Short.TYPE || target == Short.class) {
            return new Short((short)this.value);
        }
        if (target == Byte.TYPE || target == Byte.class) {
            return new Byte((byte)this.value);
        }
        if (target == Character.TYPE || target == Character.class) {
            return new Character((char)this.value);
        }
        if (target == BigInteger.class) {
            return BigInteger.valueOf(this.value);
        }
        if (target == BigDecimal.class) {
            return BigDecimal.valueOf(this.value);
        }
        Object o = super.convertToJava(target, context);
        if (o == null) {
            throw new XPathException("Conversion of integer to " + target.getName() + " is not supported");
        }
        return o;
    }

    protected static class Int64Comparable
    implements Comparable {
        protected Int64Value value;

        public Int64Comparable(Int64Value value) {
            this.value = value;
        }

        public long asLong() {
            return this.value.longValue();
        }

        public int compareTo(Object o) {
            if (o instanceof Int64Comparable) {
                long long1;
                long long0 = this.value.longValue();
                if (long0 <= (long1 = ((Int64Comparable)o).value.longValue())) {
                    if (long0 == long1) {
                        return 0;
                    }
                    return -1;
                }
                return 1;
            }
            if (o instanceof BigIntegerValue.BigIntegerComparable) {
                return this.value.asBigInteger().compareTo(((BigIntegerValue.BigIntegerComparable)o).asBigInteger());
            }
            if (o instanceof DecimalValue.DecimalComparable) {
                return this.value.getDecimalValue().compareTo(((DecimalValue.DecimalComparable)o).asBigDecimal());
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            if (o instanceof Int64Comparable) {
                return this.asLong() == ((Int64Comparable)o).asLong();
            }
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            return (int)this.asLong();
        }
    }
}

