/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.SequenceIterable;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public abstract class Value
implements Serializable,
SequenceIterable,
ValueRepresentation {
    private static double[] powers = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8};
    private static Pattern doublePattern = Pattern.compile("^[0-9.eE+-]+$");
    public static final int INDETERMINATE_ORDERING = Integer.MIN_VALUE;
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    public static Value asValue(ValueRepresentation val) {
        if (val instanceof Value) {
            return (Value)val;
        }
        if (val == null) {
            return EmptySequence.getInstance();
        }
        return new SingletonNode((NodeInfo)val);
    }

    public static Item asItem(ValueRepresentation value) throws XPathException {
        if (value instanceof Item) {
            return (Item)value;
        }
        return ((Value)value).asItem();
    }

    public Item asItem() throws XPathException {
        SequenceIterator iter = this.iterate();
        Item item = iter.next();
        if (item == null) {
            return null;
        }
        if (iter.next() != null) {
            throw new XPathException("Attempting to access a sequence as a singleton item");
        }
        return item;
    }

    public static Value fromItem(Item item) {
        if (item == null) {
            return EmptySequence.getInstance();
        }
        if (item instanceof AtomicValue) {
            return (AtomicValue)item;
        }
        return new SingletonNode((NodeInfo)item);
    }

    public static SequenceIterator asIterator(ValueRepresentation val) throws XPathException {
        if (val instanceof Value) {
            return ((Value)val).iterate();
        }
        if (val == null) {
            return EmptyIterator.getInstance();
        }
        return SingletonIterator.makeIterator((NodeInfo)val);
    }

    public static double stringToNumber(CharSequence s) throws NumberFormatException {
        String n;
        int len = s.length();
        if (len < 9) {
            boolean useJava = false;
            long num = 0L;
            int dot = -1;
            int lastDigit = -1;
            boolean onlySpaceAllowed = false;
            block5: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (lastDigit == -1) continue block5;
                        onlySpaceAllowed = true;
                        continue block5;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (onlySpaceAllowed) {
                            throw new NumberFormatException("Numeric value contains embedded whitespace");
                        }
                        lastDigit = i;
                        num = num * 10L + (long)(c - 48);
                        continue block5;
                    }
                    case '.': {
                        if (onlySpaceAllowed) {
                            throw new NumberFormatException("Numeric value contains embedded whitespace");
                        }
                        if (dot != -1) {
                            throw new NumberFormatException("Only one decimal point allowed");
                        }
                        dot = i;
                        continue block5;
                    }
                    default: {
                        useJava = true;
                        break block5;
                    }
                }
            }
            if (!useJava) {
                if (lastDigit == -1) {
                    throw new NumberFormatException("No digits found");
                }
                if (dot == -1 || dot > lastDigit) {
                    return num;
                }
                int afterPoint = lastDigit - dot;
                return (double)num / powers[afterPoint];
            }
        }
        if ("INF".equals(n = ((Object)Whitespace.trimWhitespace(s)).toString())) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-INF".equals(n)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("NaN".equals(n)) {
            return Double.NaN;
        }
        if (!doublePattern.matcher(n).matches()) {
            throw new NumberFormatException("Invalid characters in float/double value");
        }
        return Double.parseDouble(n);
    }

    public static SequenceIterator getIterator(ValueRepresentation val) throws XPathException {
        if (val instanceof Value) {
            return ((Value)val).iterate();
        }
        if (val instanceof NodeInfo) {
            return SingletonIterator.makeIterator((NodeInfo)val);
        }
        if (val == null) {
            throw new AssertionError((Object)"Value of variable is undefined (null)");
        }
        throw new AssertionError((Object)("Unknown value representation " + val.getClass()));
    }

    public abstract SequenceIterator iterate() throws XPathException;

    public final SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.iterate();
    }

    public CharSequence getStringValueCS() throws XPathException {
        return this.getStringValue();
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        try {
            return this.getStringValueCS();
        }
        catch (XPathException err) {
            throw new IllegalStateException("Failed to get canonical lexical representation: " + err.getMessage());
        }
    }

    public ItemType getItemType(TypeHierarchy th) {
        return AnyItemType.getInstance();
    }

    public int getCardinality() {
        try {
            SequenceIterator iter = this.iterate();
            Item next = iter.next();
            if (next == null) {
                return 8192;
            }
            if (iter.next() != null) {
                return 49152;
            }
            return 16384;
        }
        catch (XPathException err) {
            return 57344;
        }
    }

    public Item itemAt(int n) throws XPathException {
        Item item;
        if (n < 0) {
            return null;
        }
        int i = 0;
        SequenceIterator iter = this.iterate();
        do {
            if ((item = iter.next()) != null) continue;
            return null;
        } while (i++ != n);
        return item;
    }

    public int getLength() throws XPathException {
        return Aggregate.count(this.iterate());
    }

    public void process(XPathContext context) throws XPathException {
        Item it;
        SequenceIterator iter = this.iterate();
        SequenceReceiver out = context.getReceiver();
        while ((it = iter.next()) != null) {
            out.append(it, 0, 2);
        }
    }

    public String getStringValue() throws XPathException {
        FastStringBuffer sb = new FastStringBuffer(1024);
        SequenceIterator iter = this.iterate();
        Item item = iter.next();
        if (item != null) {
            while (true) {
                sb.append(item.getStringValueCS());
                item = iter.next();
                if (item == null) break;
                sb.append(' ');
            }
        }
        return sb.toString();
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    public Comparable getSchemaComparable() {
        return new ValueSchemaComparable();
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException("Value.equals()");
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
    }

    public Value reduce() throws XPathException {
        return this;
    }

    public Object convertToJava(Class target, XPathContext context) throws XPathException {
        XPathException err;
        Item next;
        if (target == Object.class) {
            ArrayList list = new ArrayList(20);
            return this.convertToJavaList(list, context);
        }
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (target.isAssignableFrom(SequenceIterator.class)) {
            return this.iterate();
        }
        if (!(!(this instanceof ObjectValue) && this instanceof AtomicValue || this instanceof EmptySequence)) {
            List externalObjectModels = context.getConfiguration().getExternalObjectModels();
            for (int m = 0; m < externalObjectModels.size(); ++m) {
                ExternalObjectModel model = (ExternalObjectModel)externalObjectModels.get(m);
                Object object = model.convertXPathValueToObject(this, target, context);
                if (object == null) continue;
                return object;
            }
        }
        if (Collection.class.isAssignableFrom(target)) {
            Collection list;
            if (target.isAssignableFrom(ArrayList.class)) {
                list = new ArrayList(100);
            } else {
                XPathException de;
                try {
                    list = (Collection)target.newInstance();
                }
                catch (InstantiationException e2) {
                    de = new XPathException("Cannot instantiate collection class " + target);
                    de.setXPathContext(context);
                    throw de;
                }
                catch (IllegalAccessException e3) {
                    de = new XPathException("Cannot access collection class " + target);
                    de.setXPathContext(context);
                    throw de;
                }
            }
            return this.convertToJavaList(list, context);
        }
        if (target.isArray()) {
            int length;
            Object array;
            Class<?> component = target.getComponentType();
            if (component.isAssignableFrom(Item.class) || component.isAssignableFrom(NodeInfo.class) || component.isAssignableFrom(DocumentInfo.class)) {
                Value extent = this;
                if (extent instanceof Closure) {
                    extent = Value.asValue(SequenceExtent.makeSequenceExtent(extent.iterate()));
                }
                int length2 = extent.getLength();
                array = Array.newInstance(component, length2);
                SequenceIterator iter = extent.iterate();
                for (int i = 0; i < length2; ++i) {
                    Item item = iter.next();
                    try {
                        Array.set(array, i, item);
                        continue;
                    }
                    catch (IllegalArgumentException err2) {
                        XPathException d = new XPathException("Item " + i + " in supplied sequence cannot be converted " + "to the component type of the Java array (" + component + ')', err2);
                        d.setErrorCode("SXJE0023");
                        d.setXPathContext(context);
                        throw d;
                    }
                }
                return array;
            }
            SequenceIterator it = Atomizer.getAtomizingIterator(this.iterate());
            if ((it.getProperties() & 2) == 0) {
                SequenceExtent extent = new SequenceExtent(it);
                length = extent.getLength();
                it = extent.iterate();
            } else {
                length = ((LastPositionFinder)it).getLastPosition();
            }
            array = Array.newInstance(component, length);
            for (int i = 0; i < length; ++i) {
                try {
                    AtomicValue val = (AtomicValue)it.next();
                    Object jval = val.convertToJava(component, context);
                    Array.set(array, i, jval);
                    continue;
                }
                catch (XPathException err3) {
                    XPathException d = new XPathException("Cannot convert item in atomized sequence to the component type of the Java array", err3);
                    d.setErrorCode("SXJE0023");
                    d.setXPathContext(context);
                    throw d;
                }
            }
            return array;
        }
        if (target.isAssignableFrom(Item.class) || target.isAssignableFrom(NodeInfo.class) || target.isAssignableFrom(DocumentInfo.class)) {
            SequenceIterator iter = this.iterate();
            Item first = null;
            while ((next = iter.next()) != null) {
                if (first != null) {
                    err = new XPathException("Sequence contains more than one value; Java method expects only one", "SXJE0022");
                    err.setXPathContext(context);
                    throw err;
                }
                first = next;
            }
            if (first == null) {
                return null;
            }
            if (target.isAssignableFrom(first.getClass())) {
                return first;
            }
            Object n = first;
            while (n instanceof VirtualNode) {
                Object vn = ((VirtualNode)n).getUnderlyingNode();
                if (target.isAssignableFrom(vn.getClass())) {
                    return vn;
                }
                n = vn;
            }
            throw new XPathException("Cannot convert supplied XPath value to the required type for the extension function", "SXJE0021");
        }
        if (!(this instanceof AtomicValue)) {
            SequenceIterator it = Atomizer.getAtomizingIterator(this.iterate());
            Item first = null;
            while ((next = it.next()) != null) {
                if (first != null) {
                    err = new XPathException("Sequence contains more than one value; Java method expects only one", "SXJE0022");
                    err.setXPathContext(context);
                    throw err;
                }
                first = next;
            }
            if (first == null) {
                return null;
            }
            if (target.isAssignableFrom(first.getClass())) {
                return first;
            }
            return ((AtomicValue)first).convertToJava(target, context);
        }
        throw new XPathException("Cannot convert supplied XPath value to the required type for the extension function", "SXJE0021");
    }

    private Collection convertToJavaList(Collection list, XPathContext context) throws XPathException {
        SequenceIterator iter = this.iterate();
        Item it;
        while ((it = iter.next()) != null) {
            if (it instanceof AtomicValue) {
                list.add(((AtomicValue)it).convertToJava(class$java$lang$Object == null ? Value.class$("java.lang.Object") : class$java$lang$Object, context));
                continue;
            }
            if (it instanceof VirtualNode) {
                list.add(((VirtualNode)it).getUnderlyingNode());
                continue;
            }
            list.add(it);
        }
        return list;
    }

    public static Value convertJavaObjectToXPath(Object object, SequenceType requiredType, XPathContext context) throws XPathException {
        Configuration config = context.getConfiguration();
        ItemType requiredItemType = requiredType.getPrimaryType();
        if (object == null) {
            return EmptySequence.getInstance();
        }
        List externalObjectModels = config.getExternalObjectModels();
        for (int m = 0; m < externalObjectModels.size(); ++m) {
            ExternalObjectModel model = (ExternalObjectModel)externalObjectModels.get(m);
            Value val = model.convertObjectToXPathValue(object, config);
            if (val == null || TypeChecker.testConformance(val, requiredType, context) != null) continue;
            return val;
        }
        if (requiredItemType instanceof ExternalObjectType) {
            Class theClass = ((ExternalObjectType)requiredItemType).getJavaClass();
            if (theClass.isAssignableFrom(object.getClass())) {
                return new ObjectValue(object, (ExternalObjectType)requiredItemType);
            }
            throw new XPathException("Supplied parameter value is not of class " + theClass.getName());
        }
        return Value.convertToBestFit(object, config);
    }

    private static Value convertToBestFit(Object object, Configuration config) throws XPathException {
        if (object instanceof String) {
            return StringValue.makeStringValue((String)object);
        }
        if (object instanceof Character) {
            return new StringValue(object.toString());
        }
        if (object instanceof Boolean) {
            return BooleanValue.get((Boolean)object);
        }
        if (object instanceof Double) {
            return new DoubleValue((Double)object);
        }
        if (object instanceof Float) {
            return new FloatValue(((Float)object).floatValue());
        }
        if (object instanceof Short) {
            return new Int64Value(((Short)object).shortValue(), BuiltInAtomicType.SHORT, false);
        }
        if (object instanceof Integer) {
            return new Int64Value(((Integer)object).intValue(), BuiltInAtomicType.INT, false);
        }
        if (object instanceof Long) {
            return new Int64Value((Long)object, BuiltInAtomicType.LONG, false);
        }
        if (object instanceof Byte) {
            return new Int64Value(((Byte)object).byteValue(), BuiltInAtomicType.BYTE, false);
        }
        if (object instanceof BigInteger) {
            return BigIntegerValue.makeIntegerValue((BigInteger)object);
        }
        if (object instanceof BigDecimal) {
            return new DecimalValue((BigDecimal)object);
        }
        if (object.getClass().getName().equals("javax.xml.namespace.QName")) {
            return Value.makeQNameValue(object, config);
        }
        if (object instanceof URI) {
            return new AnyURIValue(object.toString());
        }
        if (object instanceof URL) {
            return new AnyURIValue(object.toString());
        }
        if (object instanceof Date) {
            return DateTimeValue.fromJavaDate((Date)object);
        }
        if (object instanceof Closure) {
            return Value.asValue(SequenceExtent.makeSequenceExtent(((Closure)object).iterate()));
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof NodeInfo) {
            if (!((NodeInfo)object).getConfiguration().isCompatible(config)) {
                throw new XPathException("Externally-supplied NodeInfo belongs to a different and incompatible Configuration", "SXXP0004");
            }
            return new SingletonNode((NodeInfo)object);
        }
        if (object instanceof SequenceIterator) {
            return Closure.makeIteratorClosure((SequenceIterator)object);
        }
        if (object instanceof List) {
            Item[] array = new Item[((List)object).size()];
            int a = 0;
            Iterator i = ((List)object).iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (obj instanceof NodeInfo) {
                    if (!((NodeInfo)obj).getConfiguration().isCompatible(config)) {
                        throw new XPathException("Externally-supplied NodeInfo belongs to wrong Configuration", "SXXP0004");
                    }
                    array[a++] = (NodeInfo)obj;
                    continue;
                }
                Value v = Value.convertToBestFit(obj, config);
                if (v == null) continue;
                if (v instanceof Item) {
                    array[a++] = (Item)((Object)v);
                    continue;
                }
                if (v instanceof EmptySequence) continue;
                if (v instanceof SingletonNode) {
                    NodeInfo node = ((SingletonNode)v).getNode();
                    if (node == null) continue;
                    array[a++] = node;
                    continue;
                }
                throw new XPathException("Returned List contains an object that cannot be converted to an Item (" + obj.getClass() + ')', "SXJE0051");
            }
            return new SequenceExtent(array);
        }
        if (object instanceof Object[]) {
            Object[] arrayObject = (Object[])object;
            Item[] newArray = new Item[arrayObject.length];
            int a = 0;
            for (int i = 0; i < arrayObject.length; ++i) {
                Value v;
                Object itemObject = arrayObject[i];
                if (itemObject instanceof NodeInfo) {
                    if (!((NodeInfo)itemObject).getConfiguration().isCompatible(config)) {
                        throw new XPathException("Externally-supplied NodeInfo belongs to a different and incompatible Configuration", "SXXP0004");
                    }
                    newArray[a++] = (NodeInfo)itemObject;
                    continue;
                }
                if (itemObject == null || (v = Value.convertToBestFit(itemObject, config)) == null) continue;
                if (v instanceof Item) {
                    newArray[a++] = (Item)((Object)v);
                    continue;
                }
                throw new XPathException("Returned array contains an object that cannot be converted to an Item (" + itemObject.getClass() + ')', "SXJE0051");
            }
            return new SequenceExtent(newArray, 0, a);
        }
        if (object instanceof long[]) {
            Item[] array = new Item[((long[])object).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Int64Value.makeIntegerValue(((long[])object)[i]);
            }
            return new SequenceExtent(array);
        }
        if (object instanceof int[]) {
            Item[] array = new Item[((int[])object).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Int64Value.makeIntegerValue(((int[])object)[i]);
            }
            return new SequenceExtent(array);
        }
        if (object instanceof short[]) {
            Item[] array = new Item[((short[])object).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Int64Value.makeIntegerValue(((short[])object)[i]);
            }
            return new SequenceExtent(array);
        }
        if (object instanceof byte[]) {
            Item[] array = new Item[((byte[])object).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = Int64Value.makeIntegerValue(0xFF & ((byte[])object)[i]);
            }
            return new SequenceExtent(array);
        }
        if (object instanceof char[]) {
            return StringValue.makeStringValue(new String((char[])object));
        }
        if (object instanceof boolean[]) {
            Item[] array = new Item[((boolean[])object).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = BooleanValue.get(((boolean[])object)[i]);
            }
            return new SequenceExtent(array);
        }
        if (object instanceof double[]) {
            Item[] array = new Item[((double[])object).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = new DoubleValue(((double[])object)[i]);
            }
            return new SequenceExtent(array);
        }
        if (object instanceof float[]) {
            Item[] array = new Item[((float[])object).length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = new FloatValue(((float[])object)[i]);
            }
            return new SequenceExtent(array);
        }
        if (object instanceof Source && config != null) {
            if (object instanceof DOMSource) {
                NodeInfo node = config.unravel((Source)object);
                if (!node.getConfiguration().isCompatible(config)) {
                    throw new XPathException("Externally-supplied DOM Node belongs to a different and incompatible Configuration", "SXXP0004");
                }
                return new SingletonNode(node);
            }
            try {
                TinyBuilder b = new TinyBuilder();
                PipelineConfiguration pipe = config.makePipelineConfiguration();
                b.setPipelineConfiguration(pipe);
                new Sender(pipe).send((Source)object, b);
                if (object instanceof AugmentedSource && ((AugmentedSource)object).isPleaseCloseAfterUse()) {
                    ((AugmentedSource)object).close();
                }
                return new SingletonNode(b.getCurrentRoot());
            }
            catch (XPathException err) {
                throw new XPathException(err);
            }
        }
        ExternalObjectModel model = config.findExternalObjectModel(object);
        if (model != null) {
            DocumentInfo doc = model.wrapDocument(object, "", config);
            NodeInfo node = model.wrapNode(doc, object);
            return Value.asValue(node);
        }
        return new ObjectValue(object);
    }

    public static QNameValue makeQNameValue(Object object, Configuration config) {
        try {
            Class qnameClass = config.getClass("javax.xml.namespace.QName", false, null);
            Class[] args = EMPTY_CLASS_ARRAY;
            Method getPrefix = qnameClass.getMethod("getPrefix", args);
            Method getLocalPart = qnameClass.getMethod("getLocalPart", args);
            Method getNamespaceURI = qnameClass.getMethod("getNamespaceURI", args);
            String prefix = (String)getPrefix.invoke(object, (Object[])args);
            String localPart = (String)getLocalPart.invoke(object, (Object[])args);
            String uri = (String)getNamespaceURI.invoke(object, (Object[])args);
            return new QNameValue(prefix, uri, localPart, BuiltInAtomicType.QNAME, config.getNameChecker());
        }
        catch (XPathException e2) {
            return null;
        }
        catch (NoSuchMethodException e3) {
            return null;
        }
        catch (IllegalAccessException e4) {
            return null;
        }
        catch (InvocationTargetException e5) {
            return null;
        }
    }

    public String toString() {
        try {
            return this.getStringValue();
        }
        catch (XPathException err) {
            return super.toString();
        }
    }

    public static Object convertToJava(Item item) throws XPathException {
        if (item instanceof NodeInfo) {
            Object node = item;
            while (node instanceof VirtualNode) {
                node = ((VirtualNode)node).getUnderlyingNode();
            }
            return node;
        }
        if (item instanceof ObjectValue) {
            return ((ObjectValue)item).getObject();
        }
        AtomicValue value = (AtomicValue)item;
        switch (value.getItemType(null).getPrimitiveType()) {
            case 513: 
            case 518: 
            case 529: 
            case 631: {
                return value.getStringValue();
            }
            case 514: {
                return ((BooleanValue)value).getBooleanValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 515: {
                return ((DecimalValue)value).getDecimalValue();
            }
            case 532: {
                return new Long(((NumericValue)value).longValue());
            }
            case 517: {
                return new Double(((DoubleValue)value).getDoubleValue());
            }
            case 516: {
                return new Float(((FloatValue)value).getFloatValue());
            }
            case 519: {
                return ((DateTimeValue)value).getCalendar().getTime();
            }
            case 521: {
                return ((DateValue)value).getCalendar().getTime();
            }
            case 520: {
                return value.getStringValue();
            }
            case 528: {
                return ((Base64BinaryValue)value).getBinaryValue();
            }
            case 527: {
                return ((HexBinaryValue)value).getBinaryValue();
            }
        }
        return item;
    }

    private class ValueSchemaComparable
    implements Comparable {
        private ValueSchemaComparable() {
        }

        public Value getValue() {
            return Value.this;
        }

        public int compareTo(Object obj) {
            try {
                if (obj instanceof ValueSchemaComparable) {
                    Item item2;
                    Item item1;
                    int c;
                    SequenceIterator iter1 = this.getValue().iterate();
                    SequenceIterator iter2 = ((ValueSchemaComparable)obj).getValue().iterate();
                    do {
                        item1 = iter1.next();
                        item2 = iter2.next();
                        if (item1 == null && item2 == null) {
                            return 0;
                        }
                        if (item1 == null) {
                            return -1;
                        }
                        if (item2 == null) {
                            return 1;
                        }
                        if (!(item1 instanceof NodeInfo) && !(item2 instanceof NodeInfo)) continue;
                        throw new UnsupportedOperationException("Sequences containing nodes are not schema-comparable");
                    } while ((c = ((AtomicValue)item1).getSchemaComparable().compareTo(((AtomicValue)item2).getSchemaComparable())) == 0);
                    return c;
                }
                return Integer.MIN_VALUE;
            }
            catch (XPathException e2) {
                throw new AssertionError((Object)("Failure comparing schema values: " + e2.getMessage()));
            }
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public int hashCode() {
            try {
                int hash = 107189858;
                SequenceIterator iter = this.getValue().iterate();
                while (true) {
                    Item item;
                    if ((item = iter.next()) == null) {
                        return hash;
                    }
                    hash ^= ((AtomicValue)item).getSchemaComparable().hashCode();
                }
            }
            catch (XPathException e2) {
                return 0;
            }
        }
    }
}

