/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.other;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.Transform;

public class GLib {
    private static Transform<Quad, Triple> transformQuad2Triple = new Transform<Quad, Triple>(){

        @Override
        public Triple convert(Quad quad) {
            return quad.asTriple();
        }
    };
    public static Transform<Quad, Node> projectQuadGraphName = new Transform<Quad, Node>(){

        @Override
        public Node convert(Quad quad) {
            return quad.getGraph();
        }
    };
    public static Transform<Quad, Node> projectQuadSubject = new Transform<Quad, Node>(){

        @Override
        public Node convert(Quad quad) {
            return quad.getSubject();
        }
    };
    public static Transform<Quad, Node> projectQuadPredicate = new Transform<Quad, Node>(){

        @Override
        public Node convert(Quad quad) {
            return quad.getPredicate();
        }
    };
    public static Transform<Quad, Node> projectQuadObject = new Transform<Quad, Node>(){

        @Override
        public Node convert(Quad quad) {
            return quad.getObject();
        }
    };
    public static Transform<Triple, Node> projectTripeSubject = new Transform<Triple, Node>(){

        @Override
        public Node convert(Triple triple) {
            return triple.getSubject();
        }
    };
    public static Transform<Triple, Node> projectTripePredicate = new Transform<Triple, Node>(){

        @Override
        public Node convert(Triple triple) {
            return triple.getPredicate();
        }
    };
    public static Transform<Triple, Node> projectTripeObject = new Transform<Triple, Node>(){

        @Override
        public Node convert(Triple triple) {
            return triple.getObject();
        }
    };

    public static Node nullAsAny(Node x) {
        return GLib.nullAsDft(x, Node.ANY);
    }

    public static Node nullAsDft(Node x, Node dft) {
        return x == null ? dft : x;
    }

    public static Iterator<Node> listSubjects(Graph graph) {
        ExtendedIterator<Triple> iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        return Iter.iter(iter).map(projectTripeSubject).distinct();
    }

    public static Iterator<Node> listPredicates(Graph graph) {
        ExtendedIterator<Triple> iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        return Iter.iter(iter).map(projectTripePredicate).distinct();
    }

    public static Iterator<Node> listObjects(Graph graph) {
        ExtendedIterator<Triple> iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        return Iter.iter(iter).map(projectTripeObject).distinct();
    }

    public static Iter<Triple> quads2triples(Iterator<Quad> iter) {
        return Iter.iter(iter).map(transformQuad2Triple);
    }

    public static Iterator<Node> quad2graphName(Iterator<Quad> iter) {
        return Iter.map(iter, projectQuadGraphName);
    }

    public static Iterator<Node> quad2subject(Iterator<Quad> iter) {
        return Iter.map(iter, projectQuadSubject);
    }

    public static Iterator<Node> quad2predicate(Iterator<Quad> iter) {
        return Iter.map(iter, projectQuadPredicate);
    }

    public static Iterator<Node> quad2object(Iterator<Quad> iter) {
        return Iter.map(iter, projectQuadObject);
    }

    public static Iterator<Node> triple2subject(Iterator<Triple> iter) {
        return Iter.map(iter, projectTripeSubject);
    }

    public static Iterator<Node> triple2predicate(Iterator<Triple> iter) {
        return Iter.map(iter, projectTripePredicate);
    }

    public static Iterator<Node> triple2object(Iterator<Triple> iter) {
        return Iter.map(iter, projectTripeObject);
    }
}

