
        var threshold = 97;
        var displayStatus = false;
        var incompleteText = 'Incomplete';
        var completedText = 'Completed';
        var youtube = 'UcqwxpOgng0';
        var videoTitle = 'SGAME Platform';
        var metaTitle = videoTitle.replace(/&#8217;/g, '’');
        var footer = '<p>SCORM Package: SGAME Platform</p>';

$(window).load(function () {
    initialize();
    if (window.lstate === 'passed' || window.lstate === 'completed') {
        $("#progressSemantic").text(completedText); // Set intial course completion status.
        $("#progressIcon").removeClass("incomplete");
        $("#progressIcon").addClass("complete")
    } else {
        $("#progressSemantic").text(incompleteText)
    }

});

$(window).unload(function () {
    callterminate();
});

$(document).ready(function() {
    $('#title').html(videoTitle);
    $(document).attr("title", metaTitle);
    $("#footer").html(footer).text();
    if (!displayStatus) { // Only display status if set to true.
      $("#progressStatus").hide();
      }
});


var tag = document.createElement('script');

tag.src = "https://www.youtube.com/iframe_api";
var firstScriptTag = document.getElementsByTagName('script')[0];
firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

var player;

function onYouTubeIframeAPIReady() {
    player = new YT.Player('player', {
        height: '390',
        width: '640',
        videoId: youtube,
        playerVars: {'rel': 0, 'modestbranding': 1, 'showinfo': 0},
        events: {
            'onReady': onPlayerReady,
            'onStateChange': onPlayerStateChange
        }
    });
}

function onPlayerReady(event) {
    var duration = player.getDuration();
    var timer = setInterval(function () {
        var progress = player.getCurrentTime();
        var timeSpent = progress / duration;
        if (timeSpent >= threshold) {
            $("#progressIcon").removeClass("incomplete");
            $("#progressIcon").addClass("complete");
            $("#progressSemantic").text(completedText); // Set course status to completed.
            clearInterval(timer);
        }
    }, 1000);
}

function onPlayerStateChange(event) {
    if (event.data == YT.PlayerState.ENDED) {
        scoIsEnding();
        $("#progressIcon").removeClass("incomplete");
        $("#progressIcon").addClass("complete");
        $("#progressSemantic").text(completedText); // Set course status to completed.
        terminate();
    }
}

function callterminate() {
    var duration = player.getDuration();
    var progress = player.getCurrentTime();
    var timeSpent = progress / duration;
    if (timeSpent >= threshold) {
        scoIsEnding();
    }
    terminate();
}

